<?php
if (!defined('ABSPATH')) exit;

/**
 * Kirki-based settings for Social Login (Google + Facebook)
 * Requires: Kirki (plugin or embedded framework).
 * If Kirki isn't available, fields won't render (graceful degrade).
 */

add_action('init', function () {
    // Optional: If you embed Kirki, you can skip this check.
    if (!class_exists('Kirki')) return;

    Kirki::add_config('klb_social_login', [
        'capability'  => 'edit_theme_options',
        'option_type' => 'theme_mod',
    ]);



    Kirki::add_section('klb_section_social_login', [
        'title'    => esc_html__('Social Login', 'cosmetsy-core'),
        'priority' => 180,
    ]);

    // Master toggle
    Kirki::add_field('klb_social_login', [
        'type'        => 'switch',
        'settings'    => 'klb_oauth_enabled',
        'label'       => esc_html__('Enable Social Login', 'cosmetsy-core'),
        'section'     => 'klb_section_social_login',
        'default'     => true,
        'choices'     => ['on' => esc_html__('Enabled', 'cosmetsy-core'), 'off' => esc_html__('Disabled', 'cosmetsy-core')],
        'priority' => 1,
    ]);

    // Provider toggles
    Kirki::add_field('klb_social_login', [
        'type'        => 'toggle',
        'settings'    => 'klb_oauth_google_on',
        'label'       => esc_html__('Google', 'cosmetsy-core'),
        'section'     => 'klb_section_social_login',
        'default'     => true,
        'active_callback' => [['setting' => 'klb_oauth_enabled', 'operator' => '==', 'value' => true]],
        'priority' => 5,
    ]);

    // Google credentials
    Kirki::add_field('klb_social_login', [
        'type'        => 'text',
        'settings'    => 'klb_oauth_google_client_id',
        'label'       => esc_html__('Google Client ID', 'cosmetsy-core'),
        'section'     => 'klb_section_social_login',
        'sanitize_callback' => 'sanitize_text_field',
        'active_callback' => [['setting' => 'klb_oauth_google_on', 'operator' => '==', 'value' => true]],
        'priority' => 15,
    ]);
	new \Kirki\Field\Generic(
		[
			'settings'    => 'klb_oauth_google_client_secret',
			'label'       => esc_html__( 'Google Client Secret', 'cosmetsy-core' ),
			'section'     => 'klb_section_social_login',
			'default'     => '',
			'choices'     => [
				'element'  => 'input',
				'type'     => 'password',
				'style'    => 'background-color:black;color:red;',
				'data-foo' => 'bar',
			],
	        'sanitize_callback' => 'sanitize_text_field',
	        'active_callback' => [['setting' => 'klb_oauth_google_on', 'operator' => '==', 'value' => true]],
	        'priority' => 20,
		]
	);

    Kirki::add_field('klb_social_login', [
        'type'        => 'text',
        'settings'    => 'klb_oauth_label_google',
        'label'       => esc_html__('Google Button Label', 'cosmetsy-core'),
        'section'     => 'klb_section_social_login',
        'default'     => 'Google',
        'sanitize_callback' => 'sanitize_text_field',
        'active_callback' => [['setting' => 'klb_oauth_google_on', 'operator' => '==', 'value' => true]],
        'priority' => 22,
    ]);

    Kirki::add_field('klb_social_login', [
        'type'        => 'toggle',
        'settings'    => 'klb_oauth_facebook_on',
        'label'       => esc_html__('Facebook', 'cosmetsy-core'),
        'section'     => 'klb_section_social_login',
        'default'     => true,
        'active_callback' => [['setting' => 'klb_oauth_enabled', 'operator' => '==', 'value' => true]],
        'priority' => 24,
    ]);
    // Facebook credentials
    Kirki::add_field('klb_social_login', [
        'type'        => 'text',
        'settings'    => 'klb_oauth_facebook_client_id',
        'label'       => esc_html__('Facebook App ID', 'cosmetsy-core'),
        'section'     => 'klb_section_social_login',
        'sanitize_callback' => 'sanitize_text_field',
        'active_callback' => [['setting' => 'klb_oauth_facebook_on', 'operator' => '==', 'value' => true]],
        'priority' => 25,
    ]);

	new \Kirki\Field\Generic(
		[
			'settings'    => 'klb_oauth_facebook_client_secret',
			'label'       => esc_html__( 'Facebook App Secret', 'cosmetsy-core' ),
			'section'     => 'klb_section_social_login',
			'default'     => '',
			'choices'     => [
				'element'  => 'input',
				'type'     => 'password',
				'style'    => 'background-color:black;color:red;',
				'data-foo' => 'bar',
			],
	        'sanitize_callback' => 'sanitize_text_field',
	        'active_callback' => [['setting' => 'klb_oauth_facebook_on', 'operator' => '==', 'value' => true]],
	        'priority' => 30,
		]
	);

    Kirki::add_field('klb_social_login', [
        'type'        => 'text',
        'settings'    => 'klb_oauth_label_facebook',
        'label'       => esc_html__('Facebook Button Label', 'cosmetsy-core'),
        'section'     => 'klb_section_social_login',
        'default'     => 'Facebook',
        'sanitize_callback' => 'sanitize_text_field',
	    'active_callback' => [['setting' => 'klb_oauth_facebook_on', 'operator' => '==', 'value' => true]],
        'priority' => 40,
    ]);

    // Placement toggles
    Kirki::add_field('klb_social_login', [
        'type'     => 'multicheck',
        'settings' => 'klb_oauth_locations',
        'label'    => esc_html__('Show Buttons On', 'cosmetsy-core'),
        'section'  => 'klb_section_social_login',
        'default'  => ['login','register'],
        'choices'  => [
            'login'    => esc_html__('WooCommerce Login Form', 'cosmetsy-core'),
            'register' => esc_html__('WooCommerce Register Form', 'cosmetsy-core'),
        ],
        'priority' => 45,
    ]);
});
