<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\PeopleService;

class Source extends \Google\Site_Kit_Dependencies\Google\Model
{
    /**
     * Unspecified.
     */
    public const TYPE_SOURCE_TYPE_UNSPECIFIED = 'SOURCE_TYPE_UNSPECIFIED';
    /**
     * [Google Account](https://accounts.google.com).
     */
    public const TYPE_ACCOUNT = 'ACCOUNT';
    /**
     * [Google profile](https://profiles.google.com). You can view the profile at
     * [https://profiles.google.com/](https://profiles.google.com/){id}, where
     * {id} is the source id.
     */
    public const TYPE_PROFILE = 'PROFILE';
    /**
     * [Google Workspace domain
     * profile](https://support.google.com/a/answer/1628008).
     */
    public const TYPE_DOMAIN_PROFILE = 'DOMAIN_PROFILE';
    /**
     * [Google contact](https://contacts.google.com). You can view the contact at
     * [https://contact.google.com/](https://contact.google.com/){id}, where {id}
     * is the source id.
     */
    public const TYPE_CONTACT = 'CONTACT';
    /**
     * [Google "Other contact"](https://contacts.google.com/other).
     */
    public const TYPE_OTHER_CONTACT = 'OTHER_CONTACT';
    /**
     * [Google Workspace domain shared
     * contact](https://support.google.com/a/answer/9281635).
     */
    public const TYPE_DOMAIN_CONTACT = 'DOMAIN_CONTACT';
    /**
     * **Only populated in `person.metadata.sources`.** The [HTTP entity
     * tag](https://en.wikipedia.org/wiki/HTTP_ETag) of the source. Used for web
     * cache validation.
     *
     * @var string
     */
    public $etag;
    /**
     * The unique identifier within the source type generated by the server.
     *
     * @var string
     */
    public $id;
    protected $profileMetadataType = \Google\Site_Kit_Dependencies\Google\Service\PeopleService\ProfileMetadata::class;
    protected $profileMetadataDataType = '';
    /**
     * The source type.
     *
     * @var string
     */
    public $type;
    /**
     * Output only. **Only populated in `person.metadata.sources`.** Last update
     * timestamp of this source.
     *
     * @var string
     */
    public $updateTime;
    /**
     * **Only populated in `person.metadata.sources`.** The [HTTP entity
     * tag](https://en.wikipedia.org/wiki/HTTP_ETag) of the source. Used for web
     * cache validation.
     *
     * @param string $etag
     */
    public function setEtag($etag)
    {
        $this->etag = $etag;
    }
    /**
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }
    /**
     * The unique identifier within the source type generated by the server.
     *
     * @param string $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }
    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Output only. **Only populated in `person.metadata.sources`.** Metadata
     * about a source of type PROFILE.
     *
     * @param ProfileMetadata $profileMetadata
     */
    public function setProfileMetadata(\Google\Site_Kit_Dependencies\Google\Service\PeopleService\ProfileMetadata $profileMetadata)
    {
        $this->profileMetadata = $profileMetadata;
    }
    /**
     * @return ProfileMetadata
     */
    public function getProfileMetadata()
    {
        return $this->profileMetadata;
    }
    /**
     * The source type.
     *
     * Accepted values: SOURCE_TYPE_UNSPECIFIED, ACCOUNT, PROFILE, DOMAIN_PROFILE,
     * CONTACT, OTHER_CONTACT, DOMAIN_CONTACT
     *
     * @param self::TYPE_* $type
     */
    public function setType($type)
    {
        $this->type = $type;
    }
    /**
     * @return self::TYPE_*
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Output only. **Only populated in `person.metadata.sources`.** Last update
     * timestamp of this source.
     *
     * @param string $updateTime
     */
    public function setUpdateTime($updateTime)
    {
        $this->updateTime = $updateTime;
    }
    /**
     * @return string
     */
    public function getUpdateTime()
    {
        return $this->updateTime;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\PeopleService\Source::class, 'Google\\Site_Kit_Dependencies\\Google_Service_PeopleService_Source');
