jQuery( function( $ ) {
    function update_city_dropdown( state_select, city_select, cities_data ) {
        var selected_state = state_select.val();
        var defaultOptionText = 'Select an option...'; // Hardcoded fallback
        city_select.empty().append( '<option value="" disabled selected>' + defaultOptionText + '</option>' );

        if (cities_data && cities_data.hasOwnProperty(state_select.val())) {
            $.each(cities_data[state_select.val()], function(city_key, city_name) {
                if (city_key !== '') {
                    city_select.append( '<option value="' + city_key + '">' + city_name + '</option>' );
                }
            });
        }
    }

    $( document ).ready( function() {
        $( 'form.checkout' )
            .on( 'change', '#billing_state', function() {
                var state_select = $( this );
                var city_select = $( '#billing_city' );
                var cities_data = city_select.data( 'cities' );
                update_city_dropdown( state_select, city_select, cities_data );
            } )
            .on( 'change', '#shipping_state', function() {
                var state_select = $( this );
                var city_select = $( '#shipping_city' );
                var cities_data = city_select.data( 'cities' );
                update_city_dropdown( state_select, city_select, cities_data );
            } );

        // Initial load handling
        var initial_billing_state = $('#billing_state');
        var initial_billing_city = $('#billing_city');
        var initial_billing_cities_data = initial_billing_city.data('cities');
        if (initial_billing_state.val()) {
            update_city_dropdown(initial_billing_state, initial_billing_city, initial_billing_cities_data);
        } else {
            $('#billing_city').empty().append( '<option value="" disabled selected>' + wc_checkout_params.i18n_select_option + '</option>' );
        }

        var initial_shipping_state = $('#shipping_state');
        var initial_shipping_city = $('#shipping_city');
        var initial_shipping_cities_data = initial_shipping_city.data('cities');
        if ($('#ship-to-different-address-checkbox').is(':checked') && initial_shipping_state.val()) {
            update_city_dropdown(initial_shipping_state, initial_shipping_city, initial_shipping_cities_data);
        } else {
            $('#shipping_city').empty().append( '<option value="" disabled selected>' + wc_checkout_params.i18n_select_option + '</option>' );
        }
    } );

    // Trigger update_checkout when the payment method radio buttons change.
    $('form.checkout').on('change', 'input[name="payment_method"]', function() {
        $(document.body).trigger('update_checkout');
    });

    // Trigger update_checkout when the shipping method radio buttons change.
    $('form.checkout').on('change', 'input[name^="shipping_method"]', function() {
        $(document.body).trigger('update_checkout');
    });

} );