<?php



/**

 * functions.php

 * @package WordPress

 * @subpackage Cosmetsy

 * @since Cosmetsy 1.0

 * 

 */


add_action( 'wp_enqueue_scripts', 'cosmetsy_enqueue_styles', 99 );

function cosmetsy_enqueue_styles() {

    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style('custom-style',  get_stylesheet_directory_uri() .'/custom-style.css', false, 1.1);

}

/**
 * Remove postcode field from WooCommerce checkout.
 */
function kia_remove_postcode_checkout_fields( $fields ) {
    unset( $fields['billing']['billing_postcode'] );
    unset( $fields['shipping']['shipping_postcode'] );
    return $fields;
}
add_filter( 'woocommerce_checkout_fields', 'kia_remove_postcode_checkout_fields', 20 );

/**
 * Make the postcode field optional (in case some plugins still try to validate it).
 */
function kia_make_postcode_optional( $fields ) {
    if ( isset( $fields['billing_postcode'] ) ) {
        $fields['billing_postcode']['required'] = false;
    }
    if ( isset( $fields['shipping_postcode'] ) ) {
        $fields['shipping_postcode']['required'] = false;
    }
    return $fields;
}
add_filter( 'woocommerce_billing_fields', 'kia_make_postcode_optional', 20 );
add_filter( 'woocommerce_shipping_fields', 'kia_make_postcode_optional', 20 );

/**
 * Remove postcode validation.
 */
add_filter( 'woocommerce_default_address_fields', 'kia_remove_postcode_validation' );
function kia_remove_postcode_validation( $address_fields ) {
    if ( isset( $address_fields['postcode'] ) ) {
        $address_fields['postcode']['validate'] = false;
    }
    return $address_fields;
}

/**
 * Remove postcode from displayed address formats.
 */
add_filter( 'woocommerce_formatted_address_replacements', 'kia_remove_postcode_address_formats', 10, 2 );
add_filter( 'woocommerce_localisation_address_formats', 'kia_remove_postcode_address_formats', 10, 2 );
function kia_remove_postcode_address_formats( $replacements ) {
    if (func_num_args() > 1) {
        $address = func_get_arg(1); // Get the second argument if it exists
    }
    $replacements['{postcode}\n'] = '';
    $replacements['{postcode}'] = '';
    return $replacements;
}

/**
 * Remove postcode from customer address display in admin and account.
 */
add_filter( 'woocommerce_admin_billing_fields', 'kia_remove_postcode_admin_fields' );
add_filter( 'woocommerce_admin_shipping_fields', 'kia_remove_postcode_admin_fields' );
function kia_remove_postcode_admin_fields( $fields ) {
    unset( $fields['postcode'] );
    return $fields;
}

/**
 * Remove postcode from address formats used in emails.
 */
add_filter( 'woocommerce_email_customer_details_fields', 'kia_remove_postcode_email_fields', 10, 3 );
function kia_remove_postcode_email_fields( $fields, $order, $sent_to_admin ) {
    unset( $fields['billing_address']['postcode'] );
    unset( $fields['shipping_address']['postcode'] );
    return $fields;
}

/**
 * Completely remove postcode field from checkout forms.
 */
add_filter( 'woocommerce_billing_fields', 'kia_completely_remove_postcode_field', 30 );
add_filter( 'woocommerce_shipping_fields', 'kia_completely_remove_postcode_field', 30 );
function kia_completely_remove_postcode_field( $fields ) {
    unset( $fields['postcode'] );
    return $fields;
}

/**
 * Remove postcode field from frontend My Account billing address form.
 */
add_filter( 'woocommerce_billing_fields', 'kia_remove_postcode_frontend_my_account_billing' );
function kia_remove_postcode_frontend_my_account_billing( $fields ) {
    unset( $fields['billing_postcode'] );
    return $fields;
}

/**
 * Remove postcode field from frontend My Account shipping address form.
 */
add_filter( 'woocommerce_shipping_fields', 'kia_remove_postcode_frontend_my_account_shipping' );
function kia_remove_postcode_frontend_my_account_shipping( $fields ) {
    unset( $fields['shipping_postcode'] );
    return $fields;
}

/**
 * Remove postcode field from user profile edit page (backend).
 */
add_filter( 'woocommerce_customer_meta_fields', 'kia_remove_postcode_user_profile_fields' );
function kia_remove_postcode_user_profile_fields( $fields ) {
    unset( $fields['billing']['fields']['billing_postcode'] );
    unset( $fields['shipping']['fields']['shipping_postcode'] );
    return $fields;
}

// Required Phone
add_filter( 'woocommerce_checkout_fields', 'make_phone_required_checkout' );

function make_phone_required_checkout( $fields ) {
    $fields['billing']['billing_phone']['required'] = true;
    return $fields;
}

// Karachi Shipping Rates
// add_filter( 'woocommerce_package_rates', 'karachi_city_shipping_rate_v9_8_4', 10, 2 );

// function karachi_city_shipping_rate_v9_8_4( $rates, $package ) {
//     $shipping_city = isset( $package['destination']['city'] ) ? sanitize_text_field( $package['destination']['city'] ) : '';
//     $shipping_country = isset( $package['destination']['country'] ) ? sanitize_text_field( $package['destination']['country'] ) : '';

//     $karachi_rate = 250;
//     $other_city_rate = 400;
//     $pakistan_country_code = 'PK';
//     $karachi_keywords = array( 'Karachi' ); // Add variations if needed (e.g., 'karachi city')

//     $updated_rates = array();

//     error_log( 'WC 9.8.4 - Shipping Country: ' . $shipping_country );
//     error_log( 'WC 9.8.4 - Shipping City: ' . $shipping_city );
//     error_log( 'WC 9.8.4 - Available Rates: ' . print_r( $rates, true ) );

//     if ( $shipping_country === $pakistan_country_code ) {
//         $is_karachi = false;
//         foreach ( $karachi_keywords as $keyword ) {
//             if ( stripos( $shipping_city, $keyword ) !== false ) {
//                 $is_karachi = true;
//                 break;
//             }
//         }
//         error_log( 'WC 9.8.4 - Is Karachi: ' . ($is_karachi ? 'Yes' : 'No') );

//         foreach ( $rates as $rate_id => $rate ) {
//             error_log( 'WC 9.8.4 - Processing Rate ID: ' . $rate_id . ', Cost: ' . $rate->cost . ', Label: ' . $rate->label );
//             if ( $is_karachi ) {
//                 $rate->cost = $karachi_rate;
//                 $updated_rates[$rate_id] = $rate;
//                 error_log( 'WC 9.8.4 - Updated Rate for Karachi: Cost ' . $rate->cost );
//             } elseif ( ! empty( $shipping_city ) ) {
//                 $rate->cost = $other_city_rate;
//                 $updated_rates[$rate_id] = $rate;
//                 error_log( 'WC 9.8.4 - Updated Rate for Other City: Cost ' . $rate->cost );
//             } else {
//                 $updated_rates[$rate_id] = $rate;
//                 error_log( 'WC 9.8.4 - Keeping Original Rate (No City): Cost ' . $rate->cost );
//             }
//         }
//         return $updated_rates;
//     }

//     return $rates; // If not shipping to Pakistan, return original rates.
// }

// Remove States
add_filter( 'woocommerce_states', 'remove_specific_woocommerce_states' );

function remove_specific_woocommerce_states( $states ) {
    // Specify the country code for which you want to remove states (e.g., 'US' for United States, 'CA' for Canada, 'PK' for Pakistan).
    $country_code = 'PK'; // Replace with the desired country code

    // Array of state codes to remove.
    $states_to_remove = array(
        'IS', // Islamabad
        'TA', // Punjab
        // Add more state codes you want to remove
    );

    if ( isset( $states[ $country_code ] ) && is_array( $states[ $country_code ] ) ) {
        foreach ( $states_to_remove as $state_code ) {
            unset( $states[ $country_code ][ $state_code ] );
        }
    }

    return $states;
}

// City Dropdown
add_filter( 'woocommerce_checkout_fields', 'custom_city_dropdown_checkout_fields' );

function custom_city_dropdown_checkout_fields( $fields ) {
    $pakistan_provinces = array(
        '' => __( 'Select an option...', 'woocommerce' ),
        'BA' => __( 'Balochistan', 'woocommerce' ),
        'GB' => __( 'Gilgit-Baltistan', 'woocommerce' ),
        'KP' => __( 'Khyber Pakhtunkhwa', 'woocommerce' ),
        'PB' => __( 'Punjab', 'woocommerce' ),
        'SD' => __( 'Sindh', 'woocommerce' ),
        'JK' => __( 'Azad Jammu and Kashmir', 'woocommerce' ),
        // 'IS' => __( 'Islamabad Capital Territory', 'woocommerce' ),
    );

    $pakistan_cities = array(
        'BA' => array(
            '' => __( 'Select an option...', 'woocommerce' ),
            'Quetta' => __( 'Quetta', 'woocommerce' ),
            'Turbat' => __( 'Turbat', 'woocommerce' ),
            'Khuzdar' => __( 'Khuzdar', 'woocommerce' ),
            'Hub' => __( 'Hub', 'woocommerce' ),
            'Panjgur' => __( 'Panjgur', 'woocommerce' ),
            'Chaman' => __( 'Chaman', 'woocommerce' ),
            'Pishin' => __( 'Pishin', 'woocommerce' ),
            'Dera Murad Jamali' => __( 'Dera Murad Jamali', 'woocommerce' ),
            'Dera Allah Yar' => __( 'Dera Allah Yar', 'woocommerce' ),
            'Kharan' => __( 'Kharan', 'woocommerce' ),
            'Sui Town' => __( 'Sui Town', 'woocommerce' ),
            'Zehri' => __( 'Zehri', 'woocommerce' ),
            'Gwadar' => __( 'Gwadar', 'woocommerce' ),
            'Sibi' => __( 'Sibi', 'woocommerce' ),
            'Buleda' => __( 'Buleda', 'woocommerce' ),
            'Tasp' => __( 'Tasp', 'woocommerce' ),
            'Usta Mohammad' => __( 'Usta Mohammad', 'woocommerce' ),
            'Loralai' => __( 'Loralai', 'woocommerce' ),
            'Tump' => __( 'Tump', 'woocommerce' ),
            'Nushki' => __( 'Nushki', 'woocommerce' ),
            'Nal' => __( 'Nal', 'woocommerce' ),
            'Chitkan' => __( 'Chitkan', 'woocommerce' ),
            'Khanozai' => __( 'Khanozai', 'woocommerce' ),
            'Saranan' => __( 'Saranan', 'woocommerce' ),
            'Sanjawi' => __( 'Sanjawi', 'woocommerce' ),
            'Washbood' => __( 'Washbood', 'woocommerce' ),
            'Machh' => __( 'Machh', 'woocommerce' ),
            'Qalat' => __( 'Qalat', 'woocommerce' ),
            'Zhob' => __( 'Zhob', 'woocommerce' ),
            'Pasni' => __( 'Pasni', 'woocommerce' ),
            'Huramzai' => __( 'Huramzai', 'woocommerce' ),
            'Washuk' => __( 'Washuk', 'woocommerce' ),
            'Mastung' => __( 'Mastung', 'woocommerce' ),
            'Uthal' => __( 'Uthal', 'woocommerce' ),
            'Surab' => __( 'Surab', 'woocommerce' ),
            'Qilla Abdullah' => __( 'Qilla Abdullah', 'woocommerce' ),
            'Winder' => __( 'Winder', 'woocommerce' ),
            'Qilla Saifullah' => __( 'Qilla Saifullah', 'woocommerce' ),
            'Bela' => __( 'Bela', 'woocommerce' ),
            'Muslim Bagh' => __( 'Muslim Bagh', 'woocommerce' ),
            'Dera Bugti' => __( 'Dera Bugti', 'woocommerce' ),
            'Awaran' => __( 'Awaran', 'woocommerce' ),
            'Wadh' => __( 'Wadh', 'woocommerce' ),
            'Jiwani' => __( 'Jiwani', 'woocommerce' ),
            'Gandava' => __( 'Gandava', 'woocommerce' ),
            'Dalbandin' => __( 'Dalbandin', 'woocommerce' ),
            'Shahrug' => __( 'Shahrug', 'woocommerce' ),
            'Kohlu' => __( 'Kohlu', 'woocommerce' ),
            'Bhag' => __( 'Bhag', 'woocommerce' ),
            'Gajjar Mashkay' => __( 'Gajjar Mashkay', 'woocommerce' ),
            'Gadani' => __( 'Gadani', 'woocommerce' ),
            'Dhadar' => __( 'Dhadar', 'woocommerce' ),
            'Ormara' => __( 'Ormara', 'woocommerce' ),
            'Musakhel' => __( 'Musakhel', 'woocommerce' ),
            'Dureji' => __( 'Dureji', 'woocommerce' ),
            'Sohbatpur' => __( 'Sohbatpur', 'woocommerce' ),
            'Barkhan' => __( 'Barkhan', 'woocommerce' ),
            'Harnai' => __( 'Harnai', 'woocommerce' ),
            'Duki' => __( 'Duki', 'woocommerce' ),
            // Add more Balochistan cities here
        ),
        'GB' => array(
            '' => __( 'Select an option...', 'woocommerce' ),
            'Gilgit' => __( 'Gilgit', 'woocommerce' ),
            'Skardu' => __( 'Skardu', 'woocommerce' ),
            'Khaplu' => __( 'Khaplu', 'woocommerce' ),
            'Dambudas' => __( 'Dambudas', 'woocommerce' ),
            'Tolti' => __( 'Tolti', 'woocommerce' ),
            'Eidghah' => __( 'Eidghah', 'woocommerce' ),
            'Shigar' => __( 'Shigar', 'woocommerce' ),
            'Nagarkhas' => __( 'Nagarkhas', 'woocommerce' ),
            'Ishkoman' => __( 'Ishkoman', 'woocommerce' ),
            'Juglot' => __( 'Juglot', 'woocommerce' ),
            'Danyor' => __( 'Danyor', 'woocommerce' ),
            'Karimabad' => __( 'Karimabad', 'woocommerce' ),
            'Aliabad' => __( 'Aliabad', 'woocommerce' ),
            'Chilas' => __( 'Chilas', 'woocommerce' ),
            'Gahkuch' => __( 'Gahkuch', 'woocommerce' ),
            'Tangir' => __( 'Tangir', 'woocommerce' ),
            // Add more Gilgit-Baltistan cities here
        ),
        'KP' => array(
            '' => __( 'Select an option...', 'woocommerce' ),
            'Peshawar' => __( 'Peshawar', 'woocommerce' ),
            'Mardan' => __( 'Mardan', 'woocommerce' ),
            'Mingora' => __( 'Mingora', 'woocommerce' ),
            'Kohat' => __( 'Kohat', 'woocommerce' ),
            'Abbottabad' => __( 'Abbottabad', 'woocommerce' ),
            'Dera Ismail Khan' => __( 'Dera Ismail Khan', 'woocommerce' ),
            'Swabi' => __( 'Swabi', 'woocommerce' ),
            'Mansehra' => __( 'Mansehra', 'woocommerce' ),
            'Kabal' => __( 'Kabal', 'woocommerce' ),
            'Nowshera' => __( 'Nowshera', 'woocommerce' ),
            'Charsadda' => __( 'Charsadda', 'woocommerce' ),
            'Barikot' => __( 'Barikot', 'woocommerce' ),
            'Shabqadar' => __( 'Shabqadar', 'woocommerce' ),
            'Haripur' => __( 'Haripur', 'woocommerce' ),
            'Takht-i-Bahi' => __( 'Takht-i-Bahi', 'woocommerce' ),
            'Bahrain' => __( 'Bahrain', 'woocommerce' ),
            'Paharpur' => __( 'Paharpur', 'woocommerce' ),
            'Topi' => __( 'Topi', 'woocommerce' ),
            'Batkhela' => __( 'Batkhela', 'woocommerce' ),
            'Lakki Marwat' => __( 'Lakki Marwat', 'woocommerce' ),
            'Karak' => __( 'Karak', 'woocommerce' ),
            'Chitral' => __( 'Chitral', 'woocommerce' ),
            'Khwazakhela' => __( 'Khwazakhela', 'woocommerce' ),
            'Jehangira' => __( 'Jehangira', 'woocommerce' ),
            'Jamrud' => __( 'Jamrud', 'woocommerce' ),
            'Khalabat' => __( 'Khalabat', 'woocommerce' ),
            'Pabbi' => __( 'Pabbi', 'woocommerce' ),
            'Matta' => __( 'Matta', 'woocommerce' ),
            'Tank' => __( 'Tank', 'woocommerce' ),
            'Timargara' => __( 'Timargara', 'woocommerce' ),
            'Dir' => __( 'Dir', 'woocommerce' ),
            'Tordher' => __( 'Tordher', 'woocommerce' ),
            'Hangu' => __( 'Hangu', 'woocommerce' ),
            'Amangarh' => __( 'Amangarh', 'woocommerce' ),
            'Paroa' => __( 'Paroa', 'woocommerce' ),
            'Bannu' => __( 'Bannu', 'woocommerce' ),
            'Nawan Shehr' => __( 'Nawan Shehr', 'woocommerce' ),
            'Sadda' => __( 'Sadda', 'woocommerce' ),
            'Landi Kotal' => __( 'Landi Kotal', 'woocommerce' ),
            'Havelian' => __( 'Havelian', 'woocommerce' ),
            'Risalpur' => __( 'Risalpur', 'woocommerce' ),
            'Tangi' => __( 'Tangi', 'woocommerce' ),
            'Utmanzai' => __( 'Utmanzai', 'woocommerce' ),
            'Zaida' => __( 'Zaida', 'woocommerce' ),
            'Tall' => __( 'Tall', 'woocommerce' ),
            'Akora Khattak' => __( 'Akora Khattak', 'woocommerce' ),
            // Add more Khyber Pakhtunkhwa cities here
        ),
        'PB' => array(
            '' => __( 'Select an option...', 'woocommerce' ),
            'Islamabad' => __( 'Islamabad', 'woocommerce' ),
            'Lahore' => __( 'Lahore', 'woocommerce' ),
            'Faisalabad' => __( 'Faisalabad', 'woocommerce' ),
            'Rawalpindi' => __( 'Rawalpindi', 'woocommerce' ),
            'Gujranwala' => __( 'Gujranwala', 'woocommerce' ),
            'Multan' => __( 'Multan', 'woocommerce' ),
            'Sargodha' => __( 'Sargodha', 'woocommerce' ),
            'Sialkot' => __( 'Sialkot', 'woocommerce' ),
            'Bahawalpur' => __( 'Bahawalpur', 'woocommerce' ),
            'Jhang' => __( 'Jhang', 'woocommerce' ),
            'Sheikhupura' => __( 'Sheikhupura', 'woocommerce' ),
            'Gujrat' => __( 'Gujrat', 'woocommerce' ),
            'Sahiwal' => __( 'Sahiwal', 'woocommerce' ),
            'Okara' => __( 'Okara', 'woocommerce' ),
            'Rahim Yar Khan' => __( 'Rahim Yar Khan', 'woocommerce' ),
            'Kasur' => __( 'Kasur', 'woocommerce' ),
            'Dera Ghazi Khan' => __( 'Dera Ghazi Khan', 'woocommerce' ),
            'Wah Cantonment' => __( 'Wah Cantonment', 'woocommerce' ),
            'Burewala' => __( 'Burewala', 'woocommerce' ),
            'Hafizabad' => __( 'Hafizabad', 'woocommerce' ),
            'Chiniot' => __( 'Chiniot', 'woocommerce' ),
            'Jhelum' => __( 'Jhelum', 'woocommerce' ),
            'Kamoke' => __( 'Kamoke', 'woocommerce' ),
            'Khanewal' => __( 'Khanewal', 'woocommerce' ),
            'Sadiqabad' => __( 'Sadiqabad', 'woocommerce' ),
            'Muridke' => __( 'Muridke', 'woocommerce' ),
            'Khanpur' => __( 'Khanpur', 'woocommerce' ),
            'Bahawalnagar' => __( 'Bahawalnagar', 'woocommerce' ),
            'Muzaffargarh' => __( 'Muzaffargarh', 'woocommerce' ),
            'Mandi Bahauddin' => __( 'Mandi Bahauddin', 'woocommerce' ),
            'Daska' => __( 'Daska', 'woocommerce' ),
            'Pakpattan' => __( 'Pakpattan', 'woocommerce' ),
            'Chakwal' => __( 'Chakwal', 'woocommerce' ),
            'Gojra' => __( 'Gojra', 'woocommerce' ),
            'Vehari' => __( 'Vehari', 'woocommerce' ),
            'Ahmedpur East' => __( 'Ahmedpur East', 'woocommerce' ),
            'Chishtian' => __( 'Chishtian', 'woocommerce' ),
            'Samundri' => __( 'Samundri', 'woocommerce' ),
            'Ferozewala' => __( 'Ferozewala', 'woocommerce' ),
            'Attock' => __( 'Attock', 'woocommerce' ),
            'Jaranwala' => __( 'Jaranwala', 'woocommerce' ),
            'Hasilpur' => __( 'Hasilpur', 'woocommerce' ),
            'Kamalia' => __( 'Kamalia', 'woocommerce' ),
            'Kot Abdul Malik' => __( 'Kot Abdul Malik', 'woocommerce' ),
            'Arif Wala' => __( 'Arif Wala', 'woocommerce' ),
            'Gujranwala Cantonment' => __( 'Gujranwala Cantonment', 'woocommerce' ),
            'Jampur' => __( 'Jampur', 'woocommerce' ),
            'Jatoi' => __( 'Jatoi', 'woocommerce' ),
            'Wazirabad' => __( 'Wazirabad', 'woocommerce' ),
            'Layyah' => __( 'Layyah', 'woocommerce' ),
            'Shujabad' => __( 'Shujabad', 'woocommerce' ),
            'Haroonabad' => __( 'Haroonabad', 'woocommerce' ),
            'Jalalpur Jattan' => __( 'Jalalpur Jattan', 'woocommerce' ),
            'Lodhran' => __( 'Lodhran', 'woocommerce' ),
            'Kot Addu' => __( 'Kot Addu', 'woocommerce' ),
            'Mian Channu' => __( 'Mian Channu', 'woocommerce' ),
            'Khushab' => __( 'Khushab', 'woocommerce' ),
            'Rajanpur' => __( 'Rajanpur', 'woocommerce' ),
            'Taxila' => __( 'Taxila', 'woocommerce' ),
            'Bhakkar' => __( 'Bhakkar', 'woocommerce' ),
            'Narowal' => __( 'Narowal', 'woocommerce' ),
            'Mianwali' => __( 'Mianwali', 'woocommerce' ),
            'Shakargarh' => __( 'Shakargarh', 'woocommerce' ),
            'Mailsi' => __( 'Mailsi', 'woocommerce' ),
            'Dipalpur' => __( 'Dipalpur', 'woocommerce' ),
            'Haveli Lakha' => __( 'Haveli Lakha', 'woocommerce' ),
            'Lalamusa' => __( 'Lalamusa', 'woocommerce' ),
            'Sambrial' => __( 'Sambrial', 'woocommerce' ),
            'Bhalwal' => __( 'Bhalwal', 'woocommerce' ),
            'Taunsa Sharif' => __( 'Taunsa Sharif', 'woocommerce' ),
            'Phool Nagar' => __( 'Phool Nagar', 'woocommerce' ),
            'Pattoki' => __( 'Pattoki', 'woocommerce' ),
            'Jauharabad' => __( 'Jauharabad', 'woocommerce' ),
            'Chichawatni' => __( 'Chichawatni', 'woocommerce' ),
            'Farooqabad' => __( 'Farooqabad', 'woocommerce' ),
            'Sangla Hill' => __( 'Sangla Hill', 'woocommerce' ),
            'Gujar Khan' => __( 'Gujar Khan', 'woocommerce' ),
            'Kharian' => __( 'Kharian', 'woocommerce' ),
            'Pasrur' => __( 'Pasrur', 'woocommerce' ),
            'Kot Radha Kishan' => __( 'Kot Radha Kishan', 'woocommerce' ),
            'Ludhewala Waraich' => __( 'Ludhewala Waraich', 'woocommerce' ),
            'Renala Khurd' => __( 'Renala Khurd', 'woocommerce' ),
            'Kunjah' => __( 'Kunjah', 'woocommerce' ),
            'Talagang' => __( 'Talagang', 'woocommerce' ),
            // Add more Punjab cities here
        ),
        'SD' => array(
            '' => __( 'Select an option...', 'woocommerce' ),
            'Karachi' => __( 'Karachi', 'woocommerce' ),
            'Hyderabad' => __( 'Hyderabad', 'woocommerce' ),
            'Sukkur' => __( 'Sukkur', 'woocommerce' ),
            'Larkana' => __( 'Larkana', 'woocommerce' ),
            'Benazirabad' => __( 'Benazirabad', 'woocommerce' ),
            'Mirpur Khas' => __( 'Mirpur Khas', 'woocommerce' ),
            'Jacobabad' => __( 'Jacobabad', 'woocommerce' ),
            'Shikarpur' => __( 'Shikarpur', 'woocommerce' ),
            'Khairpur' => __( 'Khairpur', 'woocommerce' ),
            'Dadu' => __( 'Dadu', 'woocommerce' ),
            'Tando Adam Khan' => __( 'Tando Adam Khan', 'woocommerce' ),
            'Tando Allahyar' => __( 'Tando Allahyar', 'woocommerce' ),
            'Bolhari' => __( 'Bolhari', 'woocommerce' ),
            'Umerkot' => __( 'Umerkot', 'woocommerce' ),
            'Moro' => __( 'Moro', 'woocommerce' ),
            'Shahdadkot' => __( 'Shahdadkot', 'woocommerce' ),
            'Ghotki' => __( 'Ghotki', 'woocommerce' ),
            'Badin' => __( 'Badin', 'woocommerce' ),
            'Tando Muhammad Khan' => __( 'Tando Muhammad Khan', 'woocommerce' ),
            'Shahdadpur' => __( 'Shahdadpur', 'woocommerce' ),
            'Kamber Ali Khan' => __( 'Kamber Ali Khan', 'woocommerce' ),
            'Kotri' => __( 'Kotri', 'woocommerce' ),
            'Kandhkot' => __( 'Kandhkot', 'woocommerce' ),
            'Rohri' => __( 'Rohri', 'woocommerce' ),
            'Daharki' => __( 'Daharki', 'woocommerce' ),
            'Thul' => __( 'Thul', 'woocommerce' ),
            'Jamshoro' => __( 'Jamshoro', 'woocommerce' ),
            'Naushahro Feroze' => __( 'Naushahro Feroze', 'woocommerce' ),
            'Ratodero' => __( 'Ratodero', 'woocommerce' ),
            'Pano Akil' => __( 'Pano Akil', 'woocommerce' ),
            'Sehwan Sharif' => __( 'Sehwan Sharif', 'woocommerce' ),
            'Mirpur Mathelo' => __( 'Mirpur Mathelo', 'woocommerce' ),
            'Matli' => __( 'Matli', 'woocommerce' ),
            'Tando Jam' => __( 'Tando Jam', 'woocommerce' ),
            'Sanghar' => __( 'Sanghar', 'woocommerce' ),
            'Sakrand' => __( 'Sakrand', 'woocommerce' ),
            'Hala' => __( 'Hala', 'woocommerce' ),
            'Mehar' => __( 'Mehar', 'woocommerce' ),
            'Kashmore' => __( 'Kashmore', 'woocommerce' ),
            'Gambat' => __( 'Gambat', 'woocommerce' ),
            'Khipro' => __( 'Khipro', 'woocommerce' ),
            'Mehrabpur' => __( 'Mehrabpur', 'woocommerce' ),
            'Pir Jo Goth' => __( 'Pir Jo Goth', 'woocommerce' ),
            'Makli' => __( 'Makli', 'woocommerce' ),
            'Naudero' => __( 'Naudero', 'woocommerce' ),
            'Mithi' => __( 'Mithi', 'woocommerce' ),
            'Thatta' => __( 'Thatta', 'woocommerce' ),
            'Ubauro' => __( 'Ubauro', 'woocommerce' ),
            'Khairpur Nathan Shah' => __( 'Khairpur Nathan Shah', 'woocommerce' ),
            // Add more Sindh cities here
        ),
        'JK' => array(
            '' => __( 'Select an option...', 'woocommerce' ),
            'Muzaffarabad' => __( 'Muzaffarabad', 'woocommerce' ),
            'Mirpur' => __( 'Mirpur', 'woocommerce' ),
            'Rawalakot' => __( 'Rawalakot', 'woocommerce' ),
            'Kotli' => __( 'Kotli', 'woocommerce' ),
            'Dhirkot' => __( 'Dhirkot', 'woocommerce' ),
            'Bagh' => __( 'Bagh', 'woocommerce' ),
            'Hajira' => __( 'Hajira', 'woocommerce' ),
            'Bhimber' => __( 'Bhimber', 'woocommerce' ),
            'Palandri' => __( 'Palandri', 'woocommerce' ),
            'Chakswari' => __( 'Chakswari', 'woocommerce' ),
            'Dadyal' => __( 'Dadyal', 'woocommerce' ),
            'Khai Gala' => __( 'Khai Gala', 'woocommerce' ),
            'Islamgarh' => __( 'Islamgarh', 'woocommerce' ),
            'Pathika' => __( 'Pathika', 'woocommerce' ),
            'Hattian Bala' => __( 'Hattian Bala', 'woocommerce' ),
            'Sehnsa' => __( 'Sehnsa', 'woocommerce' ),
            'Abbaspur' => __( 'Abbaspur', 'woocommerce' ),
            'Khuiratta' => __( 'Khuiratta', 'woocommerce' ),
            'Garhi Dupatta' => __( 'Garhi Dupatta', 'woocommerce' ),
            'Athmuqam' => __( 'Athmuqam', 'woocommerce' ),
            'Charhoi' => __( 'Charhoi', 'woocommerce' ),
            'Fatehpur Thakiala' => __( 'Fatehpur Thakiala', 'woocommerce' ),
            'Forward Kahuta' => __( 'Forward Kahuta', 'woocommerce' ),
            'Chikkar' => __( 'Chikkar', 'woocommerce' ),
            'Samahni' => __( 'Samahni', 'woocommerce' ),
            // Add more Azad Jammu and Kashmir cities here
        ),
        // 'IS' => array(
        //     '' => __( 'Select an option...', 'woocommerce' ),
        //     'Islamabad' => __( 'Islamabad', 'woocommerce' ),
        // ),
    );

    // Modify billing city field
    $fields['billing']['billing_city'] = array(
        'type'            => 'select',
        'class'           => array( 'form-row-wide', 'update_totals_on_change' ),
        'label'           => __( 'Town / City', 'woocommerce' ),
        'required'        => true,
        // Set initial options to an empty array or a default "Select state first" message
        'options'         => array( '' => __( 'Select city', 'woocommerce' ) ),
        'custom_attributes' => array(
            'data-input-classes' => 'city',
            'data-cities'        => htmlspecialchars( json_encode( $pakistan_cities ) ),
        ),
        'input_class' => array(
            'wc-enhanced-select',
        )
    );
    
    // Modify shipping city field (if shipping to a different address)
    $fields['shipping']['shipping_city'] = array(
        'type'            => 'select',
        'class'           => array( 'form-row-wide', 'update_totals_on_change' ),
        'label'           => __( 'Town / City', 'woocommerce' ),
        'required'        => true,
        // Set initial options to an empty array or a default "Select state first" message
        'options'         => array( '' => __( 'Select city', 'woocommerce' ) ),
        'custom_attributes' => array(
            'data-input-classes' => 'city',
            'data-cities'        => htmlspecialchars( json_encode( $pakistan_cities ) ),
        ),
        'input_class' => array(
            'wc-enhanced-select',
        )
    );

    // Modify billing state field to a select dropdown
    $fields['billing']['billing_state'] = array(
        'type'            => 'select',
        'class'           => array( 'form-row-wide', 'address-field', 'validate-required', 'state_select' ),
        'label'           => __( 'State / County', 'woocommerce' ),
        'required'        => true,
        // Set initial options to an empty array or a default "Select state first" message
        'options'         => $pakistan_provinces,
        'input_class' => array(
            'wc-enhanced-select',
        )
    );

    // Modify shipping state field to a select dropdown
    $fields['shipping']['shipping_state'] = array(
        'type'            => 'select',
        'class'           => array( 'form-row-wide', 'address-field', 'validate-required', 'state_select' ),
        'label'           => __( 'State / County', 'woocommerce' ),
        'required'        => true,
        // Set initial options to an empty array or a default "Select state first" message
        'options'         => $pakistan_provinces,
        'input_class' => array(
            'wc-enhanced-select',
        )
    );

    wc_enqueue_js( "
    jQuery( ':input.wc-enhanced-select' ).filter( ':not(.enhanced)' ).each( function() {
        var select2_args = { minimumResultsForSearch: 5 };
        jQuery( this ).select2( select2_args ).addClass( 'enhanced' );
    });" );

    return $fields;
}

// Enqueue JavaScript file
add_action( 'wp_enqueue_scripts', 'enqueue_checkout_city_dropdown_script' );

function enqueue_checkout_city_dropdown_script() {
    if ( is_checkout() ) {
        wp_enqueue_script( 'checkout-city-dropdown', get_stylesheet_directory_uri() . '/custom-script.js', array( 'jquery' ), null, true );
    }
}

// Reorder Checkout Fields
add_filter( 'woocommerce_default_address_fields', 'reorder_checkout_fields' );
 
function reorder_checkout_fields( $fields ) {
   $fields['state']['priority'] = 70;
   $fields['city']['priority'] = 80;
   $fields['address_1']['priority'] = 90;
   $fields['address_2']['priority'] = 90;
  
   return $fields;
}

// // Store billing city in session on checkout update (still useful for AJAX updates)
// add_action( 'woocommerce_checkout_update_order_review', 'store_billing_city_in_session' );

// function store_billing_city_in_session( $post_data ) {
//     parse_str( $post_data, $output );
//     if ( isset( $output['billing_city'] ) ) {
//         WC()->session->set( 'billing_city', sanitize_text_field( $output['billing_city'] ) );
//     }
// }

// // Filter available payment gateways during the checkout process
// add_filter( 'woocommerce_available_payment_gateways', 'disable_cod_on_checkout_process' );

// function disable_cod_on_checkout_process( $available_gateways ) {
//     if ( isset( $available_gateways['cod'] ) ) {
//         $billing_city = isset( $_POST['billing_city'] ) ? sanitize_text_field( $_POST['billing_city'] ) : ( WC()->session ? WC()->session->get( 'billing_city' ) : '' );

//         if ( ! is_admin() ) {
//             if ( strtolower( trim( $billing_city ) ) !== 'karachi' ) {
//                 unset( $available_gateways['cod'] );
//             }
//         }
//     }
//     return $available_gateways;
// }

// // Clear session variable on successful order
// add_action( 'woocommerce_thankyou', 'clear_billing_city_session' );
// add_action( 'woocommerce_order_failed', 'clear_billing_city_session' );

// function clear_billing_city_session( $order_id ) {
//     $session_cookie = WC()->session->get_session_cookie();
//     if ( ! empty( $session_cookie ) && isset( $_SESSION[ $session_cookie[0] ]['billing_city'] ) ) {
//         unset( $_SESSION[ $session_cookie[0] ]['billing_city'] );
//     }
// }

/**
 * Ensures the "Ship to a different address?" checkbox and shipping fields are visible.
 *
 * This doesn't force the checkbox to be checked, but ensures the option is present
 * regardless of complex shipping zone conditions, as long as shipping is active
 * in your WooCommerce settings.
 */
function kia_ensure_shipping_address_fields_visible() {
    // This filter tells WooCommerce that the cart always needs a shipping address
    // if any product in the cart requires shipping. This is crucial for the fields to appear.
    // We return true always if shipping is generally enabled for your store.
    add_filter( 'woocommerce_cart_needs_shipping_address', '__return_true' );

    // This filter ensures that WooCommerce considers shipping is needed for the cart overall.
    // If set to false, it can hide shipping sections.
    add_filter( 'woocommerce_cart_needs_shipping', '__return_true' );
}
add_action( 'wp_loaded', 'kia_ensure_shipping_address_fields_visible' );

// Change field class
add_filter('woocommerce_checkout_fields', 'custom_checkout_billing_fields', 20, 1);
function custom_checkout_billing_fields($fields) {

    $fields['billing']['billing_first_name']['class'] = array('col-sm-6'); //  50%
    $fields['billing']['billing_last_name']['class'] = array('col-sm-6'); //  50%
    $fields['billing']['billing_address_1']['class'] = array('col-12'); //  50%
    $fields['billing']['billing_address_2']['class'] = array('col-12'); // 100%
    $fields['billing']['billing_country']['class'] = array('col-12'); // 100%
    $fields['billing']['billing_state']['class'] = array('col-sm-6'); // 100%
    $fields['billing']['billing_city']['class'] = array('col-sm-6'); // 100%
    $fields['billing']['billing_phone']['class'] = array('col-sm-6'); //  50%
    $fields['billing']['billing_email']['class'] = array('col-sm-6'); //  50%

    $fields['shipping']['shipping_first_name']['class'] = array('col-sm-6'); //  50%
    $fields['shipping']['shipping_last_name']['class'] = array('col-sm-6'); //  50%
    $fields['shipping']['shipping_address_1']['class'] = array('col-12'); //  50%
    $fields['shipping']['shipping_address_2']['class'] = array('col-12'); // 100%
    $fields['shipping']['shipping_country']['class'] = array('col-12'); // 100%
    $fields['shipping']['shipping_state']['class'] = array('col-sm-6'); // 100%
    $fields['shipping']['shipping_city']['class'] = array('col-sm-6'); // 100%

    return $fields;
}

/**
 * !!! CRITICAL WARNING: BULK PRICE UPDATE SCRIPT !!!
 *
 * This script will UPDATE THE PRICE OF ALL SIMPLE PRODUCTS IN YOUR DATABASE.
 *
 * 1. BACKUP YOUR ENTIRE DATABASE AND FILES IMMEDIATELY.
 * 2. This will compound the shipping cost if products have already been
 * updated by a previous script that saves shipping into the base price.
 * (e.g., if you've already manually saved products with the `woocommerce_admin_process_product_object` hook active).
 * 3. This will cause issues with external feeds (Google Merchant Center, Facebook Catalog).
 */

// Function to add a temporary admin notice with the bulk update trigger link
// function kia_add_bulk_price_update_admin_notice() {
//     // Only show to administrators
//     if ( current_user_can( 'manage_options' ) ) {
//         // Check if the update has been triggered already in this session
//         if ( ! get_transient( 'kia_bulk_price_update_triggered' ) ) {
//             $update_url = add_query_arg( 'kia_run_bulk_price_update', 'true', admin_url( 'admin.php?page=wc-settings' ) ); // Using WooCommerce settings page as a safe redirect target
//             echo '<div class="notice notice-warning is-dismissible">';
//             echo '<p><strong>WARNING: Bulk Price Update Available!</strong> This will update all simple product prices in your database to include shipping. **BACKUP YOUR DATABASE FIRST!** <a href="' . esc_url( $update_url ) . '" class="button button-primary">Run Bulk Price Update Now</a></p>';
//             echo '</div>';
//         } else {
//             echo '<div class="notice notice-success is-dismissible">';
//             echo '<p>Bulk Price Update has been triggered. Please check your product prices. Remember to remove this code when done.</p>';
//             echo '</div>';
//             // Delete the transient after showing the message once in this session
//             delete_transient( 'kia_bulk_price_update_triggered' );
//         }
//     }
// }
// add_action( 'admin_notices', 'kia_add_bulk_price_update_admin_notice' );

// // Function to perform the actual bulk price update
// function kia_perform_bulk_price_update() {
//     // Only run if the specific query arg is present and user is admin
//     if ( ! isset( $_GET['kia_run_bulk_price_update'] ) || $_GET['kia_run_bulk_price_update'] !== 'true' || ! current_user_can( 'manage_options' ) ) {
//         return;
//     }

//     // Set a transient to prevent running multiple times on page refresh
//     if ( get_transient( 'kia_bulk_price_update_triggered' ) ) {
//         return; // Already triggered in this session
//     }
//     set_transient( 'kia_bulk_price_update_triggered', true, MINUTE_IN_SECONDS ); // Set for 1 minute

//     // Get all simple product IDs
//     $args = array(
//         'post_type'      => 'product',
//         'post_status'    => 'publish',
//         'posts_per_page' => -1, // Get all products
//         'fields'         => 'ids', // Only get IDs for performance
//         'tax_query'      => array( // Ensure it's a simple product
//             array(
//                 'taxonomy' => 'product_type',
//                 'field'    => 'slug',
//                 'terms'    => 'simple',
//             ),
//         ),
//     );
//     $product_ids = get_posts( $args );

//     $updated_count = 0;

//     foreach ( $product_ids as $product_id ) {
//         $product = wc_get_product( $product_id );

//         if ( ! $product ) {
//             continue; // Skip if product object cannot be retrieved
//         }

//         // Get the current regular price (this is what's in the DB)
//         $current_db_price = (float) $product->get_regular_price();

//         // If product has a sale price, use the sale price for calculation if it's the effective one
//         // or ensure you're using the base price you want to add shipping to.
//         // For this scenario, we assume the 'regular price' is the base we adjust.
//         if ( empty($current_db_price) ) {
//             // Fallback if regular price is not explicitly set, use whatever get_price() returns
//             $current_db_price = (float) $product->get_price();
//         }

//         $product_weight_kg = (float) $product->get_weight();
//         if ( empty( $product_weight_kg ) || ! is_numeric( $product_weight_kg ) ) {
//             $product_weight_kg = 0;
//         }
//         $weight_in_grams = $product_weight_kg * 1000;
//         $shipping_cost_to_bundle = 0;

//         // Determine the shipping cost to bundle based on global weight tiers
//         if ( $weight_in_grams >= 0 && $weight_in_grams <= 500 ) {
//             $shipping_cost_to_bundle = 350;
//         } elseif ( $weight_in_grams > 500 && $weight_in_grams <= 1000 ) {
//             $shipping_cost_to_bundle = 600;
//         } elseif ( $weight_in_grams > 1000 && $weight_in_grams <= 2000 ) {
//             $shipping_cost_to_bundle = 800;
//         } elseif ( $weight_in_grams > 2000 && $weight_in_grams <= 3000 ) {
//             $shipping_cost_to_bundle = 1200;
//         }

//         $new_adjusted_price = $current_db_price + $shipping_cost_to_bundle;

//         // Only update if the price is different to avoid unnecessary writes
//         if ( (float) $product->get_price() !== $new_adjusted_price ) {
//             $product->set_regular_price( $new_adjusted_price );
//             $product->set_price( $new_adjusted_price );
//             $product->save(); // Save the product object to persist changes in DB
//             $updated_count++;
//         }
//     }

//     // Redirect back to admin for a clean URL
//     wp_redirect( admin_url( 'admin.php?page=wc-settings&kia_bulk_price_updated_success=' . $updated_count ) );
//     exit;
// }
// add_action( 'admin_init', 'kia_perform_bulk_price_update' );

// // Display success message after redirect
// function kia_display_bulk_price_update_success_notice() {
//     if ( isset( $_GET['kia_bulk_price_updated_success'] ) && current_user_can( 'manage_options' ) ) {
//         $count = (int) $_GET['kia_bulk_price_updated_success'];
//         echo '<div class="notice notice-success is-dismissible">';
//         echo '<p><strong>Bulk Price Update Complete!</strong> Updated ' . $count . ' simple product prices to include shipping.</p>';
//         echo '</div>';
//     }
// }
// add_action( 'admin_notices', 'kia_display_bulk_price_update_success_notice' );

/**
 * CRITICAL WARNING: This code modifies product prices in the database.
 * This is highly unconventional for handling shipping costs and will cause
 * significant issues with external platforms like Google Merchant Center
 * and Facebook Catalog. Proceed with extreme caution and full understanding
 * of the implications discussed previously.
 */

// add_action( 'woocommerce_admin_process_product_object', 'kia_update_product_price_on_admin_save', 100, 1 );

// function kia_update_product_price_on_admin_save( $product ) {
//     $product_id = $product->get_id();
//     // error_log( 'KIA Debug: kia_update_product_price_on_admin_save fired for Product ID: ' . $product_id );

//     // IMPORTANT: Check if we are saving from the admin area and not during bulk edits, imports, or other non-manual saves.
//     // This hook fires when a product is saved via the WordPress admin screen.
//     // If you need to trigger this on import/API, other hooks are required.
//     if ( ! is_admin() || ( defined( 'DOING_AJAX' ) && DOING_AJAX ) ) {
//         error_log( 'KIA Debug: Not saving from admin or it\'s an AJAX request. Skipping. Product ID: ' . $product_id );
//         return;
//     }
    
//     // Also, ensure we're not running on product variations, if you only want to affect simple products.
//     // Or add specific logic if you want to apply this to variations based on their weight.
//     if ( $product->is_type( 'variable' ) ) {
//         error_log( 'KIA Debug: Product ID ' . $product_id . ' is a variable product. Skipping base price modification. (Modify logic if variations need this)' );
//         return;
//     }

//     // For simple products, or for individual variations if you adapt the logic
//     if ( $product->is_type( 'simple' ) || $product->is_type( 'variation' ) ) {

//         // Get the base price to which the shipping cost will be added.
//         // Prioritize regular price, then sale price (if on sale), then current effective price.
//         $original_base_price = (float) $product->get_regular_price();
//         if ( empty($original_base_price) && $product->is_on_sale() ) {
//             $original_base_price = (float) $product->get_sale_price();
//         }
//         if ( empty($original_base_price) ) { // Last resort if regular/sale not explicitly set
//             $original_base_price = (float) $product->get_price();
//         }

//         // If for some reason the base price is still 0, we can't proceed meaningfully
//         if ( $original_base_price <= 0 && $product_id != 0 ) { // Check for non-zero product ID to avoid new product errors
//             error_log( 'KIA Debug: Product ' . $product_id . ' has no valid base price to adjust (' . $original_base_price . '). Skipping.' );
//             return;
//         }

//         $product_weight_kg = (float) $product->get_weight();
//         if ( empty( $product_weight_kg ) || ! is_numeric( $product_weight_kg ) ) {
//             $product_weight_kg = 0; // Default to 0 if weight is not set or invalid
//             error_log( 'KIA Debug: Product ' . $product_id . ' has no valid weight. Defaulting to 0kg.' );
//         }
//         $weight_in_grams = $product_weight_kg * 1000;
//         $shipping_cost_to_bundle = 0;

//         // Determine the shipping cost to bundle based on global weight tiers
//         if ( $weight_in_grams >= 0 && $weight_in_grams <= 500 ) {
//             $shipping_cost_to_bundle = 350;
//         } elseif ( $weight_in_grams > 500 && $weight_in_grams <= 1000 ) {
//             $shipping_cost_to_bundle = 600;
//         } elseif ( $weight_in_grams > 1000 && $weight_in_grams <= 2000 ) {
//             $shipping_cost_to_bundle = 800;
//         } elseif ( $weight_in_grams > 2000 && $weight_in_grams <= 3000 ) {
//             $shipping_cost_to_bundle = 1200;
//         }
//         // For weights > 3000g, shipping_cost_to_bundle remains 0 unless another tier is added.

//         $new_adjusted_price = $original_base_price + $shipping_cost_to_bundle;

//         // error_log( 'KIA Debug: Product ' . $product_id . ' - Original Base Price: ' . $original_base_price . ', Weight: ' . $product_weight_kg . 'kg, Bundled Cost: ' . $shipping_cost_to_bundle . ', Calculated New Price: ' . $new_adjusted_price );

//         // Check if the price needs to be updated to avoid unnecessary writes
//         // Use get_price() for the current effective price of the product object
//         if ( (float) $product->get_price() !== $new_adjusted_price ) {
//             $product->set_regular_price( $new_adjusted_price ); // Set regular price
//             $product->set_price( $new_adjusted_price );         // Set effective price (_price meta)

//             // error_log( 'KIA Debug: Product ' . $product_id . ' - Price SET to: ' . $new_adjusted_price );
//             // No need to call $product->save() here, as this hook runs just before
//             // WooCommerce's default saving process, which will persist these changes.
//         } else {
//             // error_log( 'KIA Debug: Product ' . $product_id . ' - Price is already correct (' . $new_adjusted_price . '). No update needed.' );
//         }
//     }
// }

// Keep the frontend display and cart adjustment functions if you still want that behavior.
// They were provided in previous answers. Make sure they are not commented out if needed.
// These hooks are for DISPLAY and CART only, not for saving to DB.
/*
add_filter( 'woocommerce_get_price_html', 'kia_adjust_price_display_by_weight', 10, 2 );
add_action( 'woocommerce_before_calculate_totals', 'kia_adjust_product_price_with_global_shipping', 5 );
function kia_force_shipping_calculation_and_display( $needs_shipping ) { return true; }
add_filter( 'woocommerce_cart_needs_shipping', 'kia_force_shipping_calculation_and_display' );
add_filter( 'woocommerce_cart_needs_shipping_address', 'kia_force_shipping_calculation_and_display' );
function kia_hide_shipping_total_and_show_free_shipping( $total_rows ) { /* ... */ /* }
add_filter( 'woocommerce_get_order_item_totals', 'kia_hide_shipping_total_and_show_free_shipping', 10, 1 );
function kia_change_shipping_method_label_to_free_shipping( $label, $method ) { /* ... */ /* }
add_filter( 'woocommerce_shipping_method_full_label', 'kia_change_shipping_method_label_to_free_shipping', 10, 2 );
*/

/**
 * Adjust product price based on weight (kg) and *add* to the *original* price.
 */
// function kia_adjust_price_by_weight_add_original( $price_html, $product ) {
//     if ( $product->is_type( 'simple' ) ) {
//         $product_id = $product->get_id();
//         $original_price = $product->get_regular_price(); // Or get_price() if regular and sale are the same initially
//         $weight_kg = $product->get_weight();
//         $weight_in_grams = $weight_kg * 1000;
//         $adjusted_price = $original_price; // Start with the original price

//         if ( $weight_in_grams >= 0 && $weight_in_grams <= 500 ) {
//             $adjusted_price += 350;
//         } elseif ( $weight_in_grams > 500 && $weight_in_grams <= 1000 ) {
//             $adjusted_price += 450;
//         } elseif ( $weight_in_grams > 1000 && $weight_in_grams <= 3000 ) {
//             $adjusted_price += 800;
//         }
    
//         update_post_meta( $product_id, '_regular_price', $adjusted_price );
//         update_post_meta( $product_id, '_price', $adjusted_price );
        
//         // Return the formatted price HTML
//         return wc_price( $adjusted_price );
//     }

//     return $price_html;
// }

// add_filter( 'woocommerce_get_price_html', 'kia_adjust_price_by_weight_add_original', 10, 2 );

/**
 * Adjust cart item price based on product weight.
 */
// function kia_adjust_cart_item_price_by_weight( $cart ) {
//     if ( is_admin() && ! wp_doing_ajax() ) {
//         return;
//     }

//     if ( empty( $cart->get_cart() ) ) {
//         return;
//     }

//     foreach ( $cart->get_cart() as $cart_item_key => $cart_item ) {
//         $product = $cart_item['data'];

//         if ( $product && $product->is_type( 'simple' ) ) {
//             $weight_kg = $product->get_weight();
//             $weight_in_grams = $weight_kg * 1000;
//             $original_price = $product->get_regular_price();
//             $adjusted_price = $original_price;

//             if ( $weight_in_grams >= 0 && $weight_in_grams <= 500 ) {
//                 $adjusted_price += 350;
//             } elseif ( $weight_in_grams > 500 && $weight_in_grams <= 1000 ) {
//                 $adjusted_price += 450;
//             }

//             $cart_item['data']->set_price( $adjusted_price );
//         }
//         // Handle variable products similarly if needed, accessing variation data
//     }
// }
// add_action( 'woocommerce_before_calculate_totals', 'kia_adjust_cart_item_price_by_weight', 10 );

/**
 * Adjust cart item price based on product weight.
 * This function modifies the price of products in the cart before totals are calculated.
 * It affects the main cart, mini-cart, and checkout.
 *
 * @param WC_Cart $cart_object The WooCommerce cart object.
 */
// function kia_adjust_cart_item_price_by_weight( $cart_object ) {
//     if ( is_admin() && ! wp_doing_ajax() ) {
//         return;
//     }

//     if ( empty( $cart_object->get_cart() ) ) {
//         return;
//     }

//     foreach ( $cart_object->get_cart() as $cart_item_key => $cart_item ) {
//         $product = $cart_item['data'];

//         if ( $product && $product->is_type( 'simple' ) ) {
//             $weight_kg = $product->get_weight();

//             if ( empty( $weight_kg ) || ! is_numeric( $weight_kg ) ) {
//                 $weight_kg = 0;
//             }

//             $weight_in_grams = $weight_kg * 1000;
//             $original_price = (float) $product->get_regular_price();
//             $adjusted_price = $original_price;

//             if ( $weight_in_grams >= 0 && $weight_in_grams <= 500 ) {
//                 $adjusted_price += 350;
//             } elseif ( $weight_in_grams > 500 && $weight_in_grams <= 1000 ) {
//                 $adjusted_price += 450;
//             } elseif ( $weight_in_grams > 1000 && $weight_in_grams <= 3000 ) {
//                 $adjusted_price += 800;
//             }

//             // Set the new adjusted price for the cart item product object.
//             $cart_item['data']->set_price( $adjusted_price );
//         }
//     }
// }
// add_action( 'woocommerce_before_calculate_totals', 'kia_adjust_cart_item_price_by_weight', 10 );


/**
 * Ensure mini-cart item quantity and price display the adjusted price.
 * This filter directly modifies the HTML string for each item in the mini-cart widget.
 *
 * @param string $quantity_html The HTML string for quantity and price.
 * @param array  $cart_item     The current cart item.
 * @param string $cart_item_key The current cart item key.
 * @return string Modified HTML string.
 */
// function kia_modify_mini_cart_item_quantity_html( $quantity_html, $cart_item, $cart_item_key ) {
//     $product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );

//     if ( $product && $product->is_type( 'simple' ) ) {
//         $original_price = $product->get_regular_price(); // Or get_price() if regular and sale are the same initially
//         $weight_kg = $product->get_weight();
//         $weight_in_grams = $weight_kg * 1000;
//         $adjusted_price = $original_price; // Start with the original price

//         if ( $weight_in_grams >= 0 && $weight_in_grams <= 500 ) {
//             $adjusted_price += 350;
//         } elseif ( $weight_in_grams > 500 && $weight_in_grams <= 1000 ) {
//             $adjusted_price += 450;
//         } elseif ( $weight_in_grams > 1000 && $weight_in_grams <= 3000 ) {
//             $adjusted_price += 800;
//         }
        
//         $quantity_html = sprintf( '%s &times;%s',
//             $cart_item['quantity'],
//             wc_price( $adjusted_price ) // Use wc_price to format the adjusted price
//         );
//     }

//     return $quantity_html;
// }
// add_filter( 'woocommerce_widget_cart_item_quantity', 'kia_modify_mini_cart_item_quantity_html', 10, 3 );







// /**
//  * Dynamic Price Adjustment for Karachi Customers.
//  * This code applies a Rs 250 discount to product prices in the cart
//  * if the customer's chosen shipping method belongs to the Karachi shipping zone.
//  * This assumes your product prices in the database already include any global shipping charge.
//  * The discount effectively reduces that charge for Karachi customers.
//  */

// // IMPORTANT: Replace 'flat_rate:1' with the actual Instance ID(s)
// // of the Flat Rate (or other) shipping method(s) you set up
// // for your "Karachi" Shipping Zone.
// // You found this ID in Step 1.3 above.
// // define( 'KARACHI_SHIPPING_METHOD_INSTANCE_IDS', serialize( array(
// //     'flat_rate:YOUR_KARACHI_FLAT_RATE_INSTANCE_ID_1', // Example: 'flat_rate:123'
// //     // If you have multiple shipping methods configured for Karachi,
// //     // add their instance IDs here like: 'flat_rate:456', 'another_method:789'
// // ) ) );

// add_action( 'woocommerce_before_calculate_totals', 'kia_apply_karachi_location_discount', 10, 1 );

// function kia_apply_karachi_location_discount( $cart ) {
//     // Only run if not in admin and not during AJAX requests (unless specifically needed for AJAX)
//     if ( is_admin() && ! defined( 'DOING_AJAX' ) ) {
//         return;
//     }

//     // Ensure cart is not empty
//     if ( empty( $cart->get_cart() ) ) {
//         return;
//     }

//     $discount_for_karachi = 250; // The fixed discount amount for Karachi customers

//     $is_karachi_customer = false;

//     // Check the chosen shipping methods (most reliable when shipping is calculated)
//     // if ( WC()->session && WC()->session->get( 'chosen_shipping_methods' ) ) {
//     //     $chosen_methods = (array) WC()->session->get( 'chosen_shipping_methods' );
//     //     $karachi_method_ids = unserialize( KARACHI_SHIPPING_METHOD_INSTANCE_IDS );

//     //     foreach ( $chosen_methods as $chosen_method_id ) {
//     //         if ( in_array( $chosen_method_id, $karachi_method_ids ) ) {
//     //             $is_karachi_customer = true;
//     //             break;
//     //         }
//     //     }
//     // }
//     // Fallback: If no chosen method yet (e.g., first cart page load, or customer hasn't selected shipping yet),
//     // try to guess based on customer's entered shipping city. This is less reliable.
//     // If you want the discount to appear ONLY AFTER a shipping method is selected, remove this 'else if' block.
//     if ( WC()->customer && ! empty( WC()->customer->get_shipping_city() ) ) {
//         $shipping_city = WC()->customer->get_shipping_city();
//         // Adjust 'karachi' to match exactly how the city name is entered or recognized by your shipping zones
//         if ( strtolower( $shipping_city ) === 'karachi' ) {
//             $is_karachi_customer = true;
//         }
//     }

//     // If the customer is not identified as being in Karachi, no discount.
//     if ( ! $is_karachi_customer ) {
//         return;
//     }

//     // Apply the discount to each item in the cart
//     foreach ( $cart->get_cart() as $cart_item_key => $cart_item ) {
//         $product = $cart_item['data'];

//         // Only apply to simple products (adjust logic for variations if needed)
//         if ( $product->is_type( 'simple' ) ) {
//             // Get the current product price (which already includes any global shipping charge baked in)
//             $current_price = (float) $product->get_price();

//             $product_weight_kg = (float) $product->get_weight();
//             if ( empty( $product_weight_kg ) || ! is_numeric( $product_weight_kg ) ) {
//                 $product_weight_kg = 0; // Default to 0 if weight is not set or invalid
//             }
//             $weight_in_grams = $product_weight_kg * 1000;
//             $shipping_cost_to_bundle = 0;

//             // Determine the shipping cost to bundle based on global weight tiers
//             if ( $weight_in_grams >= 0 && $weight_in_grams <= 500 ) {
//                 $shipping_cost_to_bundle = 350;
//             } elseif ( $weight_in_grams > 500 && $weight_in_grams <= 1000 ) {
//                 $shipping_cost_to_bundle = 600;
//             } elseif ( $weight_in_grams > 1000 && $weight_in_grams <= 2000 ) {
//                 $shipping_cost_to_bundle = 800;
//             } elseif ( $weight_in_grams > 2000 && $weight_in_grams <= 3000 ) {
//                 $shipping_cost_to_bundle = 1200;
//             }
//             // For weights > 3000g, shipping_cost_to_bundle remains 0 unless another tier is added.

//             // $new_adjusted_price = $current_price + $shipping_cost_to_bundle;

//             // Calculate the new price with the Karachi discount
//             $adjusted_price_for_karachi = $current_price - $shipping_cost_to_bundle + $discount_for_karachi;

//             // Ensure the price does not go below zero
//             if ( $adjusted_price_for_karachi < 0 ) {
//                 $adjusted_price_for_karachi = 0;
//             }

//             // Set the new price for the cart item
//             $cart_item['data']->set_price( $adjusted_price_for_karachi );
//         }
//     }
// }

/**
 * This code adds a custom COD shipping fee for Karachi customers based on weight.
 * It should be added to your theme's functions.php file or a custom plugin.
 */

add_filter( 'woocommerce_cart_shipping_method_full_label', 'remove_flat_rate_text_from_label', 10, 2 );

function remove_flat_rate_text_from_label( $full_label, $method ) {
    if ( strpos( $full_label, 'Flat rate:' ) !== false ) {
        $full_label = str_replace( 'Flat rate:', '', $full_label );
    }
    return $full_label;
}

add_filter( 'woocommerce_order_shipping_to_display_shipped_via', '__return_empty_string' );

add_filter( 'woocommerce_get_order_item_totals', 'custom_shipping_method_email_text', 10, 3 );

function custom_shipping_method_email_text( $total_rows, $order, $tax_display ) {
    foreach ( $total_rows as $key => $total ) {
        if ( 'shipping' === $key ) {
            $shipping_method_id = $order->get_shipping_method();
            if ( $shipping_method_id === 'flat_rate' ) { // Replace 'flat_rate' with the actual ID if different
                $total_rows[ $key ]['label'] = str_replace( 'Flat rate:', '', $total_rows[ $key ]['label'] );
            }
        }
    }
    return $total_rows;
}

add_filter( 'woocommerce_package_rates', 'adjust_shipping_cost_by_payment_method', 10, 2 );

function adjust_shipping_cost_by_payment_method( $rates, $package ) {
    // Get the chosen payment method
    $chosen_payment_method = WC()->session->get( 'chosen_payment_method' );

    $city_to_check = 'Karachi'; // Replace with the city you want to target.
    $state_to_check = 'SD'; // Replace with the state you want to target.
    $shipping_city = WC()->customer->get_shipping_city();
    $shipping_state = WC()->customer->get_shipping_state();

    // --- Calculate total cart weight ---
        $cart = WC()->cart;
        $total_weight_kg = 0;
        foreach ( $cart->get_cart() as $cart_item_key => $cart_item ) {
            $product = $cart_item['data'];
            if ( $product->has_weight() ) {
                $total_weight_kg += $product->get_weight() * $cart_item['quantity'];
            }
        }

        // Ensure a minimum weight if needed, for example, 0.5kg
        $min_weight_kg = 0.5;
        if ( $total_weight_kg < $min_weight_kg ) {
            $total_weight_kg = $min_weight_kg;
        }

        // --- Calculate the COD fee based on weight tiers ---
        $cod_fee = 0;
        

    // Loop through each shipping rate
    foreach ( $rates as $rate_key => $rate ) {
        // Example: Adjust 'flat_rate' cost if 'cod' (Cash on Delivery) is chosen
        if ( 'flat_rate' === $rate->method_id && 'cod' === $chosen_payment_method && $shipping_city === $city_to_check ) {
            if ( $total_weight_kg <= 0.5 ) {
                $cod_fee = 200;
            } elseif ( $total_weight_kg <= 1 ) {
                $cod_fee = 250;
            } elseif ( $total_weight_kg <= 2 ) {
                $cod_fee = 320;
            } elseif ( $total_weight_kg <= 3 ) {
                $cod_fee = 430;
            } else {
                // For weights over 3kg, add 140 per additional kg.
                $additional_weight_kg = $total_weight_kg - 3;
                $additional_cost = ceil( $additional_weight_kg ) * 140; // Use ceil to round up to the next kg
                $cod_fee = 430 + $additional_cost;
            }

            $rates[ $rate_key ]->cost = $cod_fee; // New cost for Cash on Delivery
        } else if ( 'flat_rate' === $rate->method_id && 'cod' === $chosen_payment_method && $shipping_state === $state_to_check ) {
            if ( $total_weight_kg <= 0.5 ) {
                $cod_fee = 250;
            } elseif ( $total_weight_kg <= 1 ) {
                $cod_fee = 300;
            } elseif ( $total_weight_kg <= 2 ) {
                $cod_fee = 320;
            } elseif ( $total_weight_kg <= 3 ) {
                $cod_fee = 450;
            } else {
                // For weights over 3kg, add 140 per additional kg.
                $additional_weight_kg = $total_weight_kg - 3;
                $additional_cost = ceil( $additional_weight_kg ) * 150; // Use ceil to round up to the next kg
                $cod_fee = 450 + $additional_cost;
            }

            $rates[ $rate_key ]->cost = $cod_fee; // New cost for Cash on Delivery
        } else if ( 'flat_rate' === $rate->method_id && 'cod' === $chosen_payment_method ) {
            if ( $total_weight_kg <= 0.5 ) {
                $cod_fee = 300;
            } elseif ( $total_weight_kg <= 1 ) {
                $cod_fee = 320;
            } elseif ( $total_weight_kg <= 2 ) {
                $cod_fee = 350;
            } elseif ( $total_weight_kg <= 3 ) {
                $cod_fee = 500;
            } else {
                // For weights over 3kg, add 140 per additional kg.
                $additional_weight_kg = $total_weight_kg - 3;
                $additional_cost = ceil( $additional_weight_kg ) * 160; // Use ceil to round up to the next kg
                $cod_fee = 500 + $additional_cost;
            }

            $rates[ $rate_key ]->cost = $cod_fee; // New cost for Cash on Delivery
        }
        // Example: Adjust 'local_pickup' cost if 'bacs' (Bank Transfer) is chosen
        elseif ( 'flat_rate' === $rate->method_id && 'bacs' === $chosen_payment_method && $shipping_city === $city_to_check ) {
            if ( $total_weight_kg <= 0.5 ) {
                $cod_fee = 200;
            } elseif ( $total_weight_kg <= 1 ) {
                $cod_fee = 250;
            } elseif ( $total_weight_kg <= 2 ) {
                $cod_fee = 300;
            } elseif ( $total_weight_kg <= 3 ) {
                $cod_fee = 360;
            } else {
                // For weights over 3kg, add 140 per additional kg.
                $additional_weight_kg = $total_weight_kg - 3;
                $additional_cost = ceil( $additional_weight_kg ) * 110; // Use ceil to round up to the next kg
                $cod_fee = 360 + $additional_cost;
            }

            $rates[ $rate_key ]->cost = $cod_fee; // New cost for Cash on Delivery
        } elseif ( 'flat_rate' === $rate->method_id && 'bacs' === $chosen_payment_method ) {
            if ( $total_weight_kg <= 0.5 ) {
                $cod_fee = 300;
            } elseif ( $total_weight_kg <= 1 ) {
                $cod_fee = 300;
            } elseif ( $total_weight_kg <= 2 ) {
                $cod_fee = 300;
            } elseif ( $total_weight_kg <= 3 ) {
                $cod_fee = 360;
            } else {
                // For weights over 3kg, add 140 per additional kg.
                $additional_weight_kg = $total_weight_kg - 3;
                $additional_cost = ceil( $additional_weight_kg ) * 110; // Use ceil to round up to the next kg
                $cod_fee = 360 + $additional_cost;
            }

            $rates[ $rate_key ]->cost = $cod_fee; // New cost for Cash on Delivery
        }
        // Add more conditions for other payment methods and shipping methods as needed
    }

    return $rates;
}

// Refresh shipping methods on payment method change (Mandatory)
add_action('woocommerce_checkout_update_order_review', 'payment_method_change_refresh_shipping_methods' );
function payment_method_change_refresh_shipping_methods() {
    if ( WC()->session->get('chosen_payment_method') ) {
        $packages = WC()->cart->get_shipping_packages();
        foreach ($packages as $package_key => $package ) {
             WC()->session->set( 'shipping_for_package_' . $package_key, false );
        }
    }
}

// Remove gla prefix from add to cart url
add_action('template_redirect', 'remove_gla_prefix_from_add_to_cart_url');
function remove_gla_prefix_from_add_to_cart_url() {
    // Check if the 'add-to-cart' parameter is present in the URL
    if (isset($_GET['add-to-cart'])) {
        $add_to_cart = $_GET['add-to-cart'];

        // Check if the 'add-to-cart' parameter starts with 'gla_'
        if (strpos($add_to_cart, 'gla_') === 0) {
            // Remove the 'gla_' prefix and update the product ID
            $product_id = str_replace('gla_', '', $add_to_cart);

            // Redirect to the correct URL without the 'gla_' prefix
            wp_safe_redirect(add_query_arg('add-to-cart', $product_id));
            exit;
        }
    }
}

?>